<?php
function sm_register_shortcode_handler_sm_featurebox() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_featurebox extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_featurebox_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_featurebox', 'sm_featurebox_func' );
	}
}

function sm_featurebox_func( $atts, $content = '' ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'featurebox', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Feature Box', 'semona-extension' ),
	'base' => 'sm_featurebox',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Feature Box', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-featurebox.png',
	'params' => array_merge(
		array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Source', 'polar-extension' ),
				'param_name' => 'icon_source',
				'value' => sm_featurebox_icon_sources_array(),
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__( 'Icon Image', 'polar-extension' ),
				'param_name' => 'icon_image',
				'dependency' => array(
					'element' => 'icon_source',
					'value' => 'image',
				)
			),
		),
		sm_get_icon_options_array( '', false, array(
			'element' => 'icon_source',
			'value' => 'font'
		) ),
		array(
			array (
				'type' => 'textfield',
				'heading' => esc_html__( 'Title', 'semona-extension' ),
				'param_name' => 'title',
				'holder' => 'div',
				'value' => '',
			),
			array (
				'type' => 'textarea',
				'heading' => esc_html__( 'Content', 'semona-extension' ),
				'holder' => 'div',
				'param_name' => 'content',
				'value' => esc_html__( 'Hey! This is content text. Feel free to put any text here.', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Title Tag', 'semona-extension' ),
				'param_name' => 'title_tag',
				'value' => sm_get_heading_tags_array(),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Position', 'semona-extension' ),
				'param_name' => 'icon_pos',
				'value' => sm_get_featurebox_icon_pos_array(),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Size', 'semona-extension' ),
				'param_name' => 'icon_size',
				'value' => sm_get_featurebox_icon_sizes_array(),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Wrap Style', 'semona-extension' ),
				'param_name' => 'icon_wrap_style',
				'value' => sm_get_featurebox_icon_wrap_styles_array(),
				'dependency' => array(
					'element' => 'icon_pos',
					'value' => array( 'sm-icon-top', 'sm-icon-left', 'sm-icon-right' )
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Wrapper Border Width', 'semona-extension' ),
				'param_name' => 'icon_wrap_border_width',
				'value' => sm_get_featurebox_border_width_array(),
				'dependency' => array(
					'element' => 'icon_wrap_style',
					'value' => array( 'sm-wrap-outlined-circle' )
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Feature Box Link', 'semona-extension' ),
				'param_name' => 'link',
				'description' => esc_html__( 'Add link to Feature box.', 'semona-extension' ),
			),
			array (
				'type' => 'textfield',
				'heading' => esc_html__( 'Link Caption', 'semona-extension' ),
				'param_name' => 'link_caption',
				'edit_field_class' => 'vc_col-sm-8 vc_column',
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Open in New Window', 'semona-extension' ),
				'param_name' => 'link_open_new',
				'edit_field_class' => 'vc_col-sm-4 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Color Style', 'semona-extension' ),
				'description' => esc_html__( 'Select Icon Color style.', 'semona-extension' ),
				'param_name' => 'icon_color_style',
				'value' => sm_get_featurebox_color_styles_array(),
				'dependency' => array(
					'element' => 'icon_source',
					'value' => 'font',
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Color', 'semona-extension' ),
				'param_name' => 'icon_color',
				'description' => esc_html__( 'Select Icon color.', 'semona-extension' ),
				'param_holder_class' => 'sm-preset-color-dropdown',
				'value' => sm_get_preset_colors_array(),
				'dependency' => array(
					'element' => 'icon_color_style',
					'value' => array( 'sm-style-solid' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Custom Icon Color',
				'param_name' => 'icon_custom_color',
				'value' => '',
				'dependency' => array(
					'element' => 'icon_color',
					'value' => array( 'custom' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			// Background
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Background Color Style', 'semona-extension' ),
				'description' => esc_html__( 'Select Icon Background Color style.', 'semona-extension' ),
				'param_name' => 'icon_bg_color_style',
				'value' => sm_get_featurebox_color_styles_array(),
				'dependency' => array(
					'element' => 'icon_wrap_style',
					'value' => array( 'sm-wrap-solid-circle', 'sm-wrap-double-circle' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Background Color', 'semona-extension' ),
				'param_name' => 'icon_bg_color',
				'description' => esc_html__( 'Select Background color.', 'semona-extension' ),
				'param_holder_class' => 'sm-preset-color-dropdown',
				'value' => sm_get_preset_bg_colors_array( true ),
				'dependency' => array(
					'element' => 'icon_bg_color_style',
					'value' => array( 'sm-style-solid' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Custom Icon Background Color',
				'param_name' => 'icon_custom_bg_color',
				'value' => '',
				'dependency' => array(
					'element' => 'icon_bg_color',
					'value' => array( 'custom' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Outline Color', 'semona-extension' ),
				'param_name' => 'icon_outline_color',
				'description' => esc_html__( 'Select Outline color.', 'semona-extension' ),
				'param_holder_class' => 'sm-preset-color-dropdown',
				'value' => sm_get_preset_border_colors_array(),
				'dependency' => array(
					'element' => 'icon_wrap_style',
					'value' => array( 'sm-wrap-outlined-circle' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Custom Outline Color',
				'param_name' => 'icon_custom_outline_color',
				'value' => '',
				'dependency' => array(
					'element' => 'icon_outline_color',
					'value' => array( 'custom' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Inner Border Color', 'semona-extension' ),
				'param_name' => 'icon_border_color',
				'description' => esc_html__( 'Select Inner Border color.', 'semona-extension' ),
				'param_holder_class' => 'sm-preset-color-dropdown',
				'value' => sm_get_preset_bg_colors_array( true ),
				'std' => 'sm-bg-color',
				'dependency' => array(
					'element' => 'icon_wrap_style',
					'value' => array( 'sm-wrap-double-circle' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Custom Inner Border Color',
				'param_name' => 'icon_custom_border_color',
				'value' => '',
				'dependency' => array(
					'element' => 'icon_border_color',
					'value' => array( 'custom' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Custom Heading Color',
				'param_name' => 'heading_color',
				'group' => esc_html__( 'Colors', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Custom Text Color',
				'param_name' => 'text_color',
				'group' => esc_html__( 'Colors', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			sm_css_animation_class(),
			sm_css_animation_delay(),
			sm_extra_class()
		)
	)
) );